/*
   This program starts a child process and has the child
   inherit (share) this program's stdin, stdout, and stderr
   streams.

   Important: This only works with Java 7. The class and
              methods used here were only recently added
              to Java!

   This program works on Linux but does not seem to work
   on Windows. See this bug report,
      http://bugs.sun.com/view_bug.do?bug_id=8023130


   Important: Notice that this program is logically the
   same as the following command line.

   C:\> java Double

   In the case of the above command line, the shell
   program (cmd.exe) runs the program Double.class
   and has it inherit the shell's stdin and stdout.
   In the case of this program, this program itself
   runs Double.class and makes sure that Double.class
   inherit's this program's stdin and stdout. So this
   program is acting like a very simple shell program.
*/
import java.io.*;

public class Java7_ChildInheritsStdStreams
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the child.
      ProcessBuilder pb = new ProcessBuilder("java", "Double");
      //ProcessBuilder pb = new ProcessBuilder("double.exe");

      // Before starting the child, tell ProcessBuilder to make
      // the child inherit its parent's streams.
      pb.redirectInput( ProcessBuilder.Redirect.INHERIT );
      pb.redirectOutput( ProcessBuilder.Redirect.INHERIT );
      pb.redirectError( ProcessBuilder.Redirect.INHERIT );

      // Now run the child process.
      Process process = pb.start();  // this throws IOException

      // Wait for the child to finish its work.
      process.waitFor();  // this throws InterruptedException
   }
}